#include <stdio.h>
#include <assert.h>
#include "UT_String.h"


class UT_String_tester
{
public:
#define DO_TEST(fn)	\
	fn();			\
	puts(#fn " passed")

	static void test()
	{
		DO_TEST(test_construction);
		DO_TEST(test_construction);
		DO_TEST(test_copy_construction);
		DO_TEST(test_addition);
		DO_TEST(test_append);
		DO_TEST(test_add_self);
		DO_TEST(test_grow);
		DO_TEST(test_shrink);
	}
private:
	static void assert_string_equality(const UT_String& s1, const UT_String& s2)
	{
		// Excercise comparison operators
		assert(s1 == s2);
		assert(!(s1 != s2));
		assert(((const char*)s1) == s2);
		assert(((const char*)s2) == s1);
		assert(s1 == ((const char*)s2));
		assert(s2 == ((const char*)s1));
		// If your compiler don't handle the following tests, just comment them
		// out. It's not like you'd encounter it in a real program.
		assert((s1.operator const char*()) == s2);
		assert((s2.operator const char*()) == s1);
		assert(s2 == (s1.operator const char*()));
		assert(s1 == (s2.operator const char*()));
	}

	static void test_construction()
	{
		const UT_String s1;			// empty
		const UT_String s2;			// empty
		const UT_String s3("foo");
		assert(s1.size() == 0);
		assert(s2.size() == 0);
		assert(s1.empty());
		assert(s2.empty());
		assert(s3.size() == 3);
		assert_string_equality(s1, s2);
		assert_string_equality(s2, s1);
		assert(s1 == "");
		assert(s2 == "");
		assert(s3 == "foo");
		printf("test_construction passed\n");
	}
	static void test_copy_construction()
	{
		const UT_String s2("foo");
		const UT_String s4(s2);
		assert(s2.size() == 3);
		assert(s4.size() == 3);
		assert_string_equality(s2, s4);
		assert_string_equality(s4, s2);
		assert(s2 == "foo");
		assert(s4 == "foo");
	}
	static void test_addition()
	{
		const UT_String s1("foo");
		const UT_String s2("bar1");
		UT_String s3 = s1 + s2;
		UT_String s4 = s1 + "bar2";
		assert(s3.size() == 7);
		assert(s4.size() == 7);
		assert(s3 == "foobar1");
		assert(s4 == "foobar2");
	}
	static void test_append()
	{
		UT_String s1("foo1");
		UT_String s2("foo2");
		const UT_String s3("bar2");
		s1 += "bar1";
		s2 += s3;
		const UT_String sRefStr1("foo1bar1");
		const UT_String sRefStr2("foo2bar2");
		assert(s1.size() == 8);
		assert(s2.size() == 8);
		assert(s1 == "foo1bar1");
		assert(s2 == "foo2bar2");
		assert_string_equality(s1, sRefStr1);
		assert_string_equality(s2, sRefStr2);
	}
	static void test_add_self()
	{
		UT_String s1("foo");
		s1 += s1;
		assert(s1.size() == 6);
		assert(s1 == "foofoo");
		s1 = s1 + s1;
		assert(s1.size() == 12);
		assert(s1 == "foofoofoofoo");
	}
	static void test_grow()
	{
		UT_String s1("foo");
		s1 += "1";
		assert(s1.size() == 4);
		assert(s1 == "foo1");
		s1 += "23";
		assert(s1.size() == 6);
		assert(s1 == "foo123");
	}
	static void test_shrink()
	{
		UT_String s1("foo123");
		assert(s1.size() == 6);	// silly
		assert(s1 == "foo123");		// silly
		s1 = "foo12";
		assert(s1.size() == 5);
		assert(s1 == "foo12");
		s1 = "foo";
		assert(s1.size() == 3);
		assert(s1 == "foo");
	}
};


int main()
{
	UT_String_tester().test();

	return 0;
}

