// UT_String.h
//
// A simple string class for use where templates are not
// allowed.
//
#ifndef UT_STRING_H
#define UT_STRING_H

#ifdef _MSC_VER
#pragma once
#endif

//
// Copyright (C) 2001 Mike Nordell <tamlin@algonet.se>
// 
// This class is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This class is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
// 02111-1307, USA.
//

#include <stdlib.h>

#if defined(UT_STRING_FOR_ABIWORD)
#include "ut_types.h"
#else
typedef bool UT_Bool;
#endif

//!
//	UT_String, a simple wrapper for char* zero terminated strings
//
class UT_String
{
public:
	UT_String();
	UT_String(const char* sz);
	UT_String(const UT_String& rhs);
	~UT_String();

	UT_String&	operator=(const UT_String& rhs);
	UT_String&	operator=(const char* rhs);
	UT_String&	operator+=(const UT_String& rhs);
	UT_String&	operator+=(const char* rhs);

	size_t		size() const;
	UT_Bool		empty() const;

	UT_Bool		operator==(const UT_String& rhs) const;
	UT_Bool		operator==(const char* rhs) const;

	// The returned pointer is only valid until the
	// next UT_String non-const operation.
	const char* c_str() const;

	// Convenience operator. Should possibly be removed
	operator const char*() const { return c_str(); }

private:
	class UT_StringImpl* pimpl;
};

// helpers
UT_Bool operator==(const char*  s1, const UT_String& s2);
UT_Bool operator!=(const UT_String& s1, const UT_String& s2);
UT_Bool operator!=(const UT_String& s1, const char*  s2);
UT_Bool operator!=(const char*  s1, const UT_String& s2);
// Intentionally lt/gt operators since this class shall
// not handle collating.
UT_String operator+(const UT_String& L, const UT_String& R);

#endif	// UT_STRING_H

